using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;

using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmTestingWorklistSpecimens
	/// </summary>
	public class FrmTestingWorklistSpecimens : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private gov.va.med.vbecs.GUI.controls.PatientSelectTool patientSelectTool1;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
        private System.Windows.Forms.Panel pnlSpecimens;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picSpecimen;
		private System.Windows.Forms.GroupBox grpSpecimens;
		private System.Windows.Forms.ListView lvSpecimens;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.DateTimePicker dtpStartDate;
		private System.Windows.Forms.DateTimePicker dtpEndDate;
		private System.Windows.Forms.Button btnSearch;
		private System.Windows.Forms.Label lblStartDate;
		private System.Windows.Forms.Label lblEndDate;
		private System.Windows.Forms.GroupBox grpDateRange;
		private System.Windows.Forms.Button btnSelectAll;
		private System.Windows.Forms.Button btnDeselectAll;
        private controls.PatientDisplayPanel patientDisplayPanel1;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmTestingWorklistSpecimens()
		{
			InitializeComponent();

			SetComponentProperties();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmTestingWorklistSpecimens));
            this.patientSelectTool1 = new gov.va.med.vbecs.GUI.controls.PatientSelectTool();
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.pnlSpecimens = new System.Windows.Forms.Panel();
            this.patientDisplayPanel1 = new gov.va.med.vbecs.GUI.controls.PatientDisplayPanel();
            this.grpDateRange = new System.Windows.Forms.GroupBox();
            this.dtpStartDate = new System.Windows.Forms.DateTimePicker();
            this.lblStartDate = new System.Windows.Forms.Label();
            this.lblEndDate = new System.Windows.Forms.Label();
            this.dtpEndDate = new System.Windows.Forms.DateTimePicker();
            this.btnSearch = new System.Windows.Forms.Button();
            this.grpSpecimens = new System.Windows.Forms.GroupBox();
            this.btnSelectAll = new System.Windows.Forms.Button();
            this.btnDeselectAll = new System.Windows.Forms.Button();
            this.lvSpecimens = new System.Windows.Forms.ListView();
            this.columnHeader1 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader2 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader3 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader4 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader5 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.picSpecimen = new System.Windows.Forms.PictureBox();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.pnlSpecimens.SuspendLayout();
            this.grpDateRange.SuspendLayout();
            this.grpSpecimens.SuspendLayout();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picSpecimen)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(660, 30);
            this.vbecsLogo1.TabIndex = 4;
            this.vbecsLogo1.Title = "Testing Worklist Report";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.TabIndex = 5;
            // 
            // patientSelectTool1
            // 
            this.patientSelectTool1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.patientSelectTool1.DisplaySIAndTRs = true;
            this.patientSelectTool1.EnabledBloodAvailButton = false;
            this.patientSelectTool1.EnabledMedicationButton = false;
            this.patientSelectTool1.EnabledRecentOrdersButton = false;
            this.patientSelectTool1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientSelectTool1.EnabledSIAndTRButton = false;
            this.patientSelectTool1.EnabledTransfusionReactionHistoryButton = false;
            this.patientSelectTool1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.patientSelectTool1.Location = new System.Drawing.Point(0, 32);
            this.patientSelectTool1.Name = "patientSelectTool1";
            this.patientSelectTool1.SearchVistaLink = false;
            this.patientSelectTool1.Size = new System.Drawing.Size(658, 412);
            this.patientSelectTool1.TabIndex = 0;
            this.patientSelectTool1.PatientSelected += new System.EventHandler(this.patientSelectTool1_PatientSelected);
            this.patientSelectTool1.PatientDeselected += new System.EventHandler(this.patientSelectTool1_PatientDeselected);
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(582, 448);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 24);
            this.btnCancel.TabIndex = 3;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.EnabledButton = false;
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = null;
            this.btnOK.Location = new System.Drawing.Point(502, 448);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 24);
            this.btnOK.TabIndex = 2;
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            // 
            // pnlSpecimens
            // 
            this.pnlSpecimens.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlSpecimens.Controls.Add(this.patientDisplayPanel1);
            this.pnlSpecimens.Controls.Add(this.grpDateRange);
            this.pnlSpecimens.Controls.Add(this.grpSpecimens);
            this.pnlSpecimens.Controls.Add(this.grpImage);
            this.pnlSpecimens.Location = new System.Drawing.Point(0, 32);
            this.pnlSpecimens.Name = "pnlSpecimens";
            this.pnlSpecimens.Size = new System.Drawing.Size(660, 412);
            this.pnlSpecimens.TabIndex = 1;
            this.pnlSpecimens.Visible = false;
            // 
            // patientDisplayPanel1
            // 
            this.patientDisplayPanel1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.patientDisplayPanel1.EnabledBloodAvailButton = false;
            this.patientDisplayPanel1.EnabledMedicationButton = false;
            this.patientDisplayPanel1.EnabledRecentOrdersButton = false;
            this.patientDisplayPanel1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientDisplayPanel1.EnabledSIAndTRButton = false;
            this.patientDisplayPanel1.EnabledTransfusionReactionHistoryButton = false;
            this.patientDisplayPanel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.patientDisplayPanel1.Location = new System.Drawing.Point(4, 0);
            this.patientDisplayPanel1.Name = "patientDisplayPanel1";
            this.patientDisplayPanel1.Patient = null;
            this.patientDisplayPanel1.Size = new System.Drawing.Size(654, 44);
            this.patientDisplayPanel1.TabIndex = 4;
            // 
            // grpDateRange
            // 
            this.grpDateRange.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpDateRange.Controls.Add(this.dtpStartDate);
            this.grpDateRange.Controls.Add(this.lblStartDate);
            this.grpDateRange.Controls.Add(this.lblEndDate);
            this.grpDateRange.Controls.Add(this.dtpEndDate);
            this.grpDateRange.Controls.Add(this.btnSearch);
            this.grpDateRange.Location = new System.Drawing.Point(48, 44);
            this.grpDateRange.Name = "grpDateRange";
            this.grpDateRange.Size = new System.Drawing.Size(608, 48);
            this.grpDateRange.TabIndex = 2;
            this.grpDateRange.TabStop = false;
            this.grpDateRange.Text = "Specimen Search Criteria";
            // 
            // dtpStartDate
            // 
            this.dtpStartDate.CustomFormat = "MM/dd/yyyy";
            this.dtpStartDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpStartDate.Location = new System.Drawing.Point(164, 20);
            this.dtpStartDate.Name = "dtpStartDate";
            this.dtpStartDate.Size = new System.Drawing.Size(116, 20);
            this.dtpStartDate.TabIndex = 1;
            // 
            // lblStartDate
            // 
            this.lblStartDate.Location = new System.Drawing.Point(8, 20);
            this.lblStartDate.Name = "lblStartDate";
            this.lblStartDate.Size = new System.Drawing.Size(160, 20);
            this.lblStartDate.TabIndex = 0;
            this.lblStartDate.Text = "Specimen Received Start Date";
            this.lblStartDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblEndDate
            // 
            this.lblEndDate.Location = new System.Drawing.Point(320, 20);
            this.lblEndDate.Name = "lblEndDate";
            this.lblEndDate.Size = new System.Drawing.Size(52, 20);
            this.lblEndDate.TabIndex = 2;
            this.lblEndDate.Text = "End Date";
            this.lblEndDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // dtpEndDate
            // 
            this.dtpEndDate.CustomFormat = "MM/dd/yyyy";
            this.dtpEndDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpEndDate.Location = new System.Drawing.Point(376, 20);
            this.dtpEndDate.Name = "dtpEndDate";
            this.dtpEndDate.Size = new System.Drawing.Size(100, 20);
            this.dtpEndDate.TabIndex = 3;
            // 
            // btnSearch
            // 
            this.btnSearch.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnSearch.Image = ((System.Drawing.Image)(resources.GetObject("btnSearch.Image")));
            this.btnSearch.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnSearch.Location = new System.Drawing.Point(524, 16);
            this.btnSearch.Name = "btnSearch";
            this.btnSearch.Size = new System.Drawing.Size(75, 23);
            this.btnSearch.TabIndex = 4;
            this.btnSearch.Text = "&Search";
            this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
            // 
            // grpSpecimens
            // 
            this.grpSpecimens.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpSpecimens.Controls.Add(this.btnSelectAll);
            this.grpSpecimens.Controls.Add(this.btnDeselectAll);
            this.grpSpecimens.Controls.Add(this.lvSpecimens);
            this.grpSpecimens.Location = new System.Drawing.Point(48, 96);
            this.grpSpecimens.Name = "grpSpecimens";
            this.grpSpecimens.Size = new System.Drawing.Size(608, 316);
            this.grpSpecimens.TabIndex = 3;
            this.grpSpecimens.TabStop = false;
            this.grpSpecimens.Text = "Select Specimen(s) to Include in Report*";
            // 
            // btnSelectAll
            // 
            this.btnSelectAll.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnSelectAll.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.btnSelectAll.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectAll.Image")));
            this.btnSelectAll.Location = new System.Drawing.Point(584, 0);
            this.btnSelectAll.Name = "btnSelectAll";
            this.btnSelectAll.Size = new System.Drawing.Size(16, 16);
            this.btnSelectAll.TabIndex = 2;
            this.btnSelectAll.Click += new System.EventHandler(this.btnSelectAll_Click);
            // 
            // btnDeselectAll
            // 
            this.btnDeselectAll.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnDeselectAll.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.btnDeselectAll.Image = ((System.Drawing.Image)(resources.GetObject("btnDeselectAll.Image")));
            this.btnDeselectAll.Location = new System.Drawing.Point(568, 0);
            this.btnDeselectAll.Name = "btnDeselectAll";
            this.btnDeselectAll.Size = new System.Drawing.Size(16, 16);
            this.btnDeselectAll.TabIndex = 1;
            this.btnDeselectAll.Click += new System.EventHandler(this.btnDeselectAll_Click);
            // 
            // lvSpecimens
            // 
            this.lvSpecimens.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvSpecimens.CheckBoxes = true;
            this.lvSpecimens.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader1,
            this.columnHeader2,
            this.columnHeader3,
            this.columnHeader4,
            this.columnHeader5});
            this.lvSpecimens.FullRowSelect = true;
            this.lvSpecimens.Location = new System.Drawing.Point(8, 16);
            this.lvSpecimens.MultiSelect = false;
            this.lvSpecimens.Name = "lvSpecimens";
            this.lvSpecimens.Size = new System.Drawing.Size(592, 292);
            this.lvSpecimens.TabIndex = 0;
            this.lvSpecimens.UseCompatibleStateImageBehavior = false;
            this.lvSpecimens.View = System.Windows.Forms.View.Details;
            this.lvSpecimens.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvSpecimens_ColumnClick);
            this.lvSpecimens.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvSpecimens_ItemCheck);
            // 
            // columnHeader1
            // 
            this.columnHeader1.Text = "Select";
            this.columnHeader1.Width = 45;
            // 
            // columnHeader2
            // 
            this.columnHeader2.Text = "Specimen UID";
            this.columnHeader2.Width = 80;
            // 
            // columnHeader3
            // 
            this.columnHeader3.Text = "Expires";
            this.columnHeader3.Width = 80;
            // 
            // columnHeader4
            // 
            this.columnHeader4.Text = "Phlebotomist";
            this.columnHeader4.Width = 80;
            // 
            // columnHeader5
            // 
            this.columnHeader5.Text = "Associated Orders";
            this.columnHeader5.Width = 290;
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.picSpecimen);
            this.grpImage.Location = new System.Drawing.Point(4, 44);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(40, 368);
            this.grpImage.TabIndex = 1;
            this.grpImage.TabStop = false;
            // 
            // picSpecimen
            // 
            this.picSpecimen.Image = ((System.Drawing.Image)(resources.GetObject("picSpecimen.Image")));
            this.picSpecimen.Location = new System.Drawing.Point(4, 12);
            this.picSpecimen.Name = "picSpecimen";
            this.picSpecimen.Size = new System.Drawing.Size(32, 36);
            this.picSpecimen.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.picSpecimen.TabIndex = 0;
            this.picSpecimen.TabStop = false;
            // 
            // FrmTestingWorklistSpecimens
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(660, 473);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnOK);
            this.Controls.Add(this.pnlSpecimens);
            this.Controls.Add(this.patientSelectTool1);
            this.hlphelpChm.SetHelpKeyword(this, "Patient_Testing_Worklist_and_Testing_Worklist_Reports.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(668, 500);
            this.Name = "FrmTestingWorklistSpecimens";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Testing Worklist Report";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmTestingWorklistSpecimens_KeyDownSpeakMessage);
            this.Controls.SetChildIndex(this.patientSelectTool1, 0);
            this.Controls.SetChildIndex(this.pnlSpecimens, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.pnlSpecimens.ResumeLayout(false);
            this.grpDateRange.ResumeLayout(false);
            this.grpSpecimens.ResumeLayout(false);
            this.grpImage.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.picSpecimen)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		/// <summary>
		/// Get patient selected for reporting
		/// </summary>
		public BOL.Patient Patient
		{
			get
			{
			    return this.patientDisplayPanel1.Patient;
			}
		}

		/// <summary>
		/// Get patient specimens selected for reporting
		/// </summary>
		public System.Collections.ArrayList Specimens
		{
			get
			{
				System.Collections.ArrayList specimens = new System.Collections.ArrayList(this.lvSpecimens.CheckedItems.Count);
				foreach(ListViewItem lvi in this.lvSpecimens.CheckedItems)
				{
					specimens.Add((BOL.Specimen)lvi.Tag);
				}
				return specimens;
			}
		}

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			//
			this.patientSelectTool1.SearchVistaLink = false;
			this.patientSelectTool1.Visible = true;
			//
			this.dtpStartDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpEndDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			//
			DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime().Date;
			this.dtpStartDate.Value = currentDate.AddDays(-90);
			this.dtpEndDate.Value = currentDate;
			this.dtpEndDate.MaxDate = currentDate;
			this.dtpStartDate.MaxDate = currentDate;
			//
			this.pnlSpecimens.Visible = false;
			//
			this.SetThisToolTip(this.btnCancel,Common.StrRes.Tooltips.Common.Cancel());
		}

		private void patientSelectTool1_PatientDeselected(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = false;
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectPatient().ResString);
		}

		private void patientSelectTool1_PatientSelected(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = true;
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		private void GetSpecimens()
		{
			System.Collections.ArrayList specimens = this.patientSelectTool1.SelectedPatient.GetAllSpecimensForPatient(this.dtpStartDate.Value,this.dtpEndDate.Value);
			if (specimens.Count>0)
			{
				//BR_48.01
				this.LoadPatientSpecimens(specimens);

			}
			else
			{
				//BR_48.15
				this.lvSpecimens.Items.Clear();
				this.lvSpecimens.CheckBoxes = false;
				ListViewItem lvi = new ListViewItem();
				lvi.Tag = null;
				lvi.SubItems.Add(Common.StrRes.InfoMsg.UC020.NoMatchingEntries().ResString);
				this.lvSpecimens.Items.Add(lvi);
				controls.VbecsFunction.SetColumnWidths(this.lvSpecimens);
				this.btnOK.EnabledButton = false;
				//
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectSpecimen().ResString);
			}
			//
			if (patientSelectTool1.Visible)
			{
                this.patientDisplayPanel1.Patient = this.patientSelectTool1.SelectedPatient;
				this.pnlSpecimens.Visible = true;
				this.patientSelectTool1.Visible = false;
			}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			if (patientSelectTool1.Visible)
			{
				int count = this.patientSelectTool1.SelectedPatient.GetAllSpecimensForPatientCount();
				if (count == 0)
				{
					//BR_48.01
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC048.NoSpecimensForPatient());
					return;
				}
				this.GetSpecimens();
			}
			else
			{
				this.DialogResult = DialogResult.OK;
				this.Close();
			}
		}

		private string GetAssociatedOrdersString(BOL.Specimen specimen)
		{
			System.Data.DataTable orderedTests = BOL.OrderedTest.GetOrderedTestsforSpecimen(specimen.SpecimenGuid);
			System.Data.DataRow[] orders = orderedTests.Select("",Common.DatabaseConstants.ArtificialColumnNames.RequestedProcedure);
			string associatedOrders = "";
			foreach(System.Data.DataRow dr in orders)
			{
				if (associatedOrders.IndexOf(dr[Common.DatabaseConstants.ArtificialColumnNames.RequestedProcedure].ToString())<0)
				{
					if (associatedOrders.Length > 0)
					{
						associatedOrders += ", ";
					}
					associatedOrders += dr[Common.DatabaseConstants.ArtificialColumnNames.RequestedProcedure].ToString();
				}
			}
			return associatedOrders;
		}

		private void LoadPatientSpecimens(System.Collections.ArrayList specimens)
		{
			using (new WaitCursor())
			{
				this.lvSpecimens.Items.Clear();
				this.lvSpecimens.CheckBoxes = true;
				//
				foreach(BOL.Specimen specimen in specimens)
				{
					//
					ListViewItem lvi = new ListViewItem();
					lvi.Tag = specimen;
					lvi.Checked = true;
					lvi.SubItems.Add(specimen.SpecimenUid);
					lvi.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(specimen.SpecimenExpirationDate));
					lvi.SubItems.Add(specimen.Phlebotomist.ToString());
					lvi.SubItems.Add(GetAssociatedOrdersString(specimen));
					//
					this.lvSpecimens.Items.Add(lvi);
				}
				//
				controls.VbecsFunction.SetColumnWidths(this.lvSpecimens);
			}
		}

		private void lvSpecimens_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 2)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, this.lvSpecimens.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, this.lvSpecimens.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		private void lvSpecimens_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if ((e.NewValue == CheckState.Checked) || ((e.NewValue == CheckState.Unchecked) && (this.lvSpecimens.CheckedItems.Count>1)))
			{
				this.btnOK.EnabledButton = true;
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			}
			else
			{
				this.btnOK.EnabledButton = false;
				//
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectSpecimen().ResString);
			}
		}

		private void btnSearch_Click(object sender, System.EventArgs e)
		{
			this.GetSpecimens();
		}

		private void btnDeselectAll_Click(object sender, System.EventArgs e)
		{
			if (this.lvSpecimens.CheckBoxes == true)
			{
				foreach(ListViewItem lvi in this.lvSpecimens.CheckedItems)
				{
					lvi.Checked = false;
				}
			}
		}

		private void btnSelectAll_Click(object sender, System.EventArgs e)
		{
			if (this.lvSpecimens.CheckBoxes == true)
			{
				foreach(ListViewItem lvi in this.lvSpecimens.Items)
				{
					lvi.Checked = true;
				}
			}
		}
		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmTestingWorklistSpecimens_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";
			if(this.patientSelectTool1.Visible)
			{
				textToSpeak = string.Concat(textToSpeak, this.patientSelectTool1.GetErrorMessagesFor508());
			}
			
			if(this.patientDisplayPanel1.Visible)
			{
				textToSpeak = string.Concat(textToSpeak, this.patientDisplayPanel1.GetErrorMessagesFor508());
			}

			this.SpeakMessage( textToSpeak );		
		}
	}
}

